(function(exports) {
exports.show = function(sensorsId, count)
{
	//if (!$.isEmptyObject(sensorsId)) //comited issue: https://gitlab.k-org.net/firmware/pc_soft/HTML_gen/issues/48
	{
		let h3 = $(`<h3>`).text(l100n.localize_string("ext_Channels_header"))
		let sensors_head = $('<div>').text(l100n.localize_string("1 Wire accordion header")).addClass("accordion-header")
		let sensors_body = $('<div>').addClass("accordion-body")

		let table = $('<table>')
		//let table_head = $('<tr>').addClass('table_header').append($('<td colspan="2">').text(l100n.localize_string("ext_Channel")))
	    //table.append(table_head)

		table.append(common.form_tag_tr_param({name: l100n.localize_string("ext_enable"), index: 0x4C04, sub: 1}))
		//table.append(common.form_tag_tr_param({name: l100n.localize_string("ext_command"), index: 0x4C03, sub: 1}))
		let scan_button = $(`<input type="submit" value="${l100n.localize_string("ext_scan_button")}" id="scan_button">`)
		let scan_button_tr = $('<tr>').append($('<td>').text(l100n.localize_string("ext_scan_label"))).append($('<td>').append(scan_button))
		table.append(scan_button_tr)

		let sensors_table = $('<table>');
		let  sensors_table_head = $('<tr>').addClass('table_header')
		sensors_table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Channel")))
	    sensors_table_head.append($('<td colspan="1">').text(l100n.localize_string("ext_Settings")))
		sensors_table_head.append($('<td colspan="1">').text(l100n.localize_string("AI Read Float")))
		sensors_table.append(sensors_table_head)

		for (let sensor_number = 1; sensor_number <= count; sensor_number++)
		{
			configuration.add_template({"index": `4C08_${sensor_number}`,"template": "one_wire_sensors", "commands": get_commands(sensorsId)})
			let tr = $('<tr class="can_hide">').append($('<td>').text(`${sensor_number}`))
			tr.append($('<td>').append($('<div class="sensor_select">').addClass("tag").attr({"index": `4C08:${sensor_number}`})))
			tr.append($('<td>').append($('<div>').addClass("tag").attr({"index": `4C31:${sensor_number}`})))
			sensors_table.append(tr)
		}

		sensors_body.append(table).append(sensors_table)
		$("#one_wire_settings").append(h3).append(sensors_head).append(sensors_body)
		//$("#io_settings").append(sensors_div)
	}
}

let button_command_xhr = new XMLHttpRequest()
$(document).on('click', '#scan_button', function()
{
	let query = `/set_od_data.form?0x4C03_1=0x6e616353`
	button_command_xhr.open('GET', query, true)
	button_command_xhr.send()

	setTimeout(reset_sensors_ids, configuration.one_wire_scan_timeout)
})

function reset_sensors_ids()
{
	exports.get_sensors_data()
	.then(data => {
		let commands = get_commands(data.ids)
		console.log(commands)
		$('.one_wire_sensors').each(function() {
			$(this).empty()
			let select = $(this)
			$.each(commands, function(commands_index, command_item)
			{
				var option = $('<option>')
				option.val(command_item.command)
				option.text(command_item.name)
				select.append(option)
			})
		})
	})
}

exports.get_sensors_data = function() 
{
	return exports.request_sensors_count()
	.then(text => common.response_ready(text))
	.then(count => exports.request_sensors_all(count, configuration.response_lenght()))
	.then(values => {
		return {'ids': values.filter(element => element !== "0x0"), 'sensors_count': values.length}
	})
}


function get_commands(sensorsId)
{
	let commands = [{"name": l100n.localize_string("not selected"), "command": "0x0"}]
	sensorsId.forEach(function(id, i) {
		commands.push({"name": id, "command": id})
	})
	return commands
}

exports.request_sensors_count = function()
{
	let query = '/get_od_data.form?';
	query += `0x4C0A_0`; //sensors count

	return fetch(query).then(response => response.text())
}

exports.request_sensors = function(start, count)
{
	let query = '/get_od_data.form?'
	for (let sensor_number = start; sensor_number < start + count; sensor_number++)
	{
		if (sensor_number > start) { query += "&"; }
		query += `0x4C0A_${sensor_number}`; //sensor ID
	}
	return fetch(query).then(response => response.text())
}

exports.request_sensors_all = async function(count, request_lenght)
{
	let one_wire_sensors_values = []
	for (let current_index = 1; current_index < count; current_index += request_lenght)
	{
		await one_wire.request_sensors(current_index, Math.min((count-current_index+1), request_lenght))
		.then(text => common.response_ready(text))
		.then(values => {
			one_wire_sensors_values = one_wire_sensors_values.concat(values)
		})
	}
	
	return one_wire_sensors_values
}
})(this.one_wire = {})
